/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.DetailsFrameBean;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPAddressBean
extends PanelBean
implements SettingsConstants,
SettingsErrorIds {
    private String m_sMacAddr;
    private String[] m_sPublicPrivateSettingSelection;
    private String m_sMediaSpeed;
    private ValueDescriptor[] m_cdMediaSpeed;
    private boolean m_bPartitionCommunication;
    private boolean m_bDHCPServerEnabled;
    private String m_sDHCPServerAddrRange;
    private ValueDescriptor[] m_cdDHCPServerAddrRange;
    private String[] m_sDHCPClientSelection;
    private String m_sIPAddr;
    private String m_sMask;
    private NetworkInterfaceInformation _netif;
    private NetworkSettingsConfig netSetConfig;
    private boolean offerPartComm;
    private boolean partComm;
    private NetworkInterfaceConfig[] netIfConfigArray;
    private NetworkInterfaceConfig netIfConfig;
    private DHCPServerRangeConfig[] dhcpServerRangeConfigArray;
    private DHCPServerRangeConfig selectedRangeConfig;
    private Integer _netifIndex;
    private String macaddrText;
    private String ifName;
    private boolean MCPLinux = false;
    private boolean configured = false;
    private static final String TRACE_MASKT = "XSETIPBT";
    private static final String TRACE_MASKF = "XSETIPBF";
    private static final String TRACE_MASKD = "XSETIPBD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "IPAddressBean");

    public String getMacAddr() {
        return this.m_sMacAddr;
    }

    public void setMacAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IPAddressBean: setMacAddr run: " + s);
        this.m_sMacAddr = s;
    }

    public String[] getPublicPrivateSettingSelection() {
        return this.m_sPublicPrivateSettingSelection;
    }

    public void setPublicPrivateSettingSelection(String[] selected) throws IllegalUserDataException {
        if (selected.length > 0) {
            Trace.trace(TRACE_MASKT, "-> IPAddressBean: setPublicPrivateSettingSelection run: selected = [" + selected[0] + "]");
        } else {
            Trace.trace(TRACE_MASKT, "-> IPAddressBean: setPublicPrivateSettingSelection called: ERROR - NO VALUE");
        }
        Trace.trace(TRACE_MASKT, "IPAddressBean: selection was: " + this.getPublicPrivateSettingSelection()[0] + "; now changed to: " + selected[0]);
        this.m_sPublicPrivateSettingSelection = selected;
        if (selected.length > 0) {
            if (selected[0].endsWith("PUBLICBUTTON")) {
                Trace.trace(TRACE_MASKT, "SetPubPriv: Disable DHCPServer");
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", false);
                this.setDHCPServerEnabled(false);
            } else {
                Trace.trace(TRACE_MASKT, "SetPubPriv: Enable DHCPServer");
                this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", true);
                this.setDHCPServerEnabled(this.isDHCPServerEnabled());
            }
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean: setPublicPrivateSettingSelection");
    }

    public String getMediaSpeed() {
        return this.m_sMediaSpeed;
    }

    public void setMediaSpeed(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IPAddressBean: setMediaSpeed: [" + s + "]");
        this.m_sMediaSpeed = s;
    }

    public ValueDescriptor[] getMediaSpeedList() {
        Trace.trace(TRACE_MASKT, "IPAddressBean: getMediaSpeedList run: " + this.m_bDHCPServerEnabled);
        return this.m_cdMediaSpeed;
    }

    public boolean isPartitionCommunication() {
        return this.m_bPartitionCommunication;
    }

    public void setPartitionCommunication(boolean b) throws IllegalUserDataException {
        this.m_bPartitionCommunication = b;
    }

    public boolean isDHCPServerEnabled() {
        Trace.trace(TRACE_MASKT, "IPAddressBean: isDHCPServerEnabled run: " + this.m_bDHCPServerEnabled);
        return this.m_bDHCPServerEnabled;
    }

    public void setDHCPServerEnabled(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean: setDHCPServerEnabled: " + b);
        this.m_bDHCPServerEnabled = b;
        if (b) {
            this.m_cdDHCPServerAddrRange = new ValueDescriptor[this.dhcpServerRangeConfigArray.length];
            for (int i = 0; i < this.dhcpServerRangeConfigArray.length; ++i) {
                String range = this.dhcpServerRangeConfigArray[i].getStart() + " - " + this.dhcpServerRangeConfigArray[i].getEnd();
                this.m_cdDHCPServerAddrRange[i] = new ValueDescriptor(range, range);
                Trace.trace(TRACE_MASKT, "m_cdDHCPServerAddrRange[" + i + "] = " + range);
            }
            this.userTaskManager.setEnabled(this.getMountPrefix() + "AddressRange", true);
            Trace.trace(TRACE_MASKT, "setDHCPServer: Enable DHCPServer Address Range");
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
            this.setDHCPServerAddrRange(this.getDHCPServerAddrRange());
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "AddressRange", false);
            Trace.trace(TRACE_MASKT, "setDHCPServer:Disable DHCPServer Address Range");
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", true);
            this.m_cdDHCPServerAddrRange = new ValueDescriptor[0];
            this.m_sDHCPServerAddrRange = "";
            if (this.getDHCPClientSelection()[0].endsWith("MANUALBUTTON")) {
                this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", true);
                this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", true);
            }
            this.refreshMyElements();
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean: setDHCPServerEnabled");
    }

    public String getDHCPServerAddrRange() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean: getDHCPServerAddrRange: [" + this.m_sDHCPServerAddrRange + "]");
        if (this.m_sDHCPServerAddrRange == "") {
            Trace.trace(TRACE_MASKT, "m_sDHCPServerAddrRange is null");
            if (this.m_cdDHCPServerAddrRange.length > 0) {
                this.m_sDHCPServerAddrRange = this.m_cdDHCPServerAddrRange[0].getName();
                Trace.trace(TRACE_MASKT, "Set selection to 1st element");
            } else {
                Trace.trace(TRACE_MASKT, "List is empty - no selection possible");
            }
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean: getDHCPServerAddrRange: [" + this.m_sDHCPServerAddrRange + "]");
        return this.m_sDHCPServerAddrRange;
    }

    public void setDHCPServerAddrRange(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean: setDHCPServerAddrRange: [" + s + "]");
        this.m_sDHCPServerAddrRange = s;
        boolean done = false;
        if (this.m_cdDHCPServerAddrRange != null) {
            for (int i = 0; i < this.m_cdDHCPServerAddrRange.length && !done; ++i) {
                Trace.trace(TRACE_MASKT, "m_cdDHCPServerAddrRange[" + i + "].getName() = " + this.m_cdDHCPServerAddrRange[i].getName());
                if (!this.m_sDHCPServerAddrRange.equals(this.m_cdDHCPServerAddrRange[i].getName())) continue;
                String hmcName = this.dhcpServerRangeConfigArray[i].getHmcAddress();
                String mask = this.dhcpServerRangeConfigArray[i].getMask();
                Trace.trace(TRACE_MASKT, "dhcpServerRangeConfigArray[i].getHmcAddress() = " + this.dhcpServerRangeConfigArray[i].getHmcAddress() + ";  dhcpServerRangeConfigArray[i].getMask() = " + this.dhcpServerRangeConfigArray[i].getMask());
                this.setIPAddr(hmcName);
                this.setMask(mask);
                done = true;
            }
            String[] fixedAddr = new String[]{this.getMountPrefix() + "MANUALBUTTON"};
            this.setDHCPClientSelection(fixedAddr);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
            this.refreshMyElements();
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean: setDHCPServerAddrRange");
    }

    public ValueDescriptor[] getDHCPServerAddrRangeList() {
        Trace.trace(TRACE_MASKT, "IPAddressBean: getDHCPServerAddrRangeList");
        return this.m_cdDHCPServerAddrRange;
    }

    public String[] getDHCPClientSelection() {
        return this.m_sDHCPClientSelection;
    }

    public void setDHCPClientSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IPAddressBean: setDHCPClientSelection run: " + selected[0]);
        if (selected[0].length() < 14) {
            System.out.println("What's going on here? IGNORE this bad call!!!");
        } else {
            this.m_sDHCPClientSelection = selected;
            if (selected.length > 0 && this.getMountPrefix() != null) {
                Trace.trace(TRACE_MASKT, "selected[0] = " + selected[0]);
                if (selected[0].endsWith("MANUALBUTTON")) {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", true);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", true);
                } else {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
                }
            }
            this.refreshMyElements();
        }
    }

    public String getIPAddr() {
        return this.m_sIPAddr;
    }

    public void setIPAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IPAddressBean: setIPAddr run: " + s);
        if (this.ifName.equals("eth0") && s.equals("0.0.0.0")) {
            Trace.trace(TRACE_MASKT, "Illegal address for eth0 - make it localhost instead");
            s = "127.0.0.1";
        }
        this.m_sIPAddr = s;
    }

    public String getMask() {
        return this.m_sMask;
    }

    public void setMask(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "IPAddressBean: setMask run: " + s);
        this.m_sMask = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.prepare()");
        if (this._netif.isDhcpClient()) {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
        } else {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "MANUALBUTTON"});
        }
        this.m_sPublicPrivateSettingSelection = this._netif.isPrivateIf() ? new String[]{this.getMountPrefix() + "PRIVATEBUTTON"} : new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
        Trace.trace(TRACE_MASKT, "isDhcpClient() = " + this._netif.isDhcpClient() + "; isPrivateIf() = " + this._netif.isPrivateIf());
        if (!this.MCPLinux) {
            this.userTaskManager.setShown(this.getMountPrefix() + "DHCPSERVERINFOBOX", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "PublicPrivateGroup", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "SPEEDINFOBOX", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "PartitionComm", false);
            this.setDHCPServerEnabled(false);
        } else {
            this.userTaskManager.setShown(this.getMountPrefix() + "PartitionComm", this.offerPartComm);
        }
        String[] publicLan = new String[]{""};
        String[] privateLan = new String[]{""};
        if (this.netIfConfig != null && this.MCPLinux) {
            Trace.trace(TRACE_MASKT, "Setup initial values according to config file");
            int pubpriv = this.netIfConfig.getInterfaceType();
            Trace.trace(TRACE_MASKT, "-> InterfaceType = [" + pubpriv + "]");
            switch (pubpriv) {
                case 0: {
                    publicLan = new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
                    this.setPublicPrivateSettingSelection(publicLan);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "PRIVATEBUTTON", false);
                    break;
                }
                case 1: {
                    privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                    this.setPublicPrivateSettingSelection(privateLan);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "PUBLICBUTTON", false);
                    break;
                }
                default: {
                    if (this.configured) {
                        Trace.trace(TRACE_MASKT, "Configured previously; Pub/Priv setting = [" + this.getPublicPrivateSettingSelection()[0] + "]");
                        if (this.getPublicPrivateSettingSelection()[0].endsWith("PUBLICBUTTON")) {
                            publicLan = new String[]{this.getMountPrefix() + "PUBLICBUTTON"};
                            this.setPublicPrivateSettingSelection(publicLan);
                            break;
                        }
                        privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                        this.setPublicPrivateSettingSelection(privateLan);
                        break;
                    }
                    privateLan = new String[]{this.getMountPrefix() + "PRIVATEBUTTON"};
                    this.setPublicPrivateSettingSelection(privateLan);
                    Trace.trace(TRACE_MASKT, "Lan default set private; (PHMC default)");
                }
            }
            Trace.trace(TRACE_MASKT, "<- InterfaceType = [" + pubpriv + "]");
            int addrType = this.netIfConfig.getAddressType();
            Trace.trace(TRACE_MASKT, "-> AddressType = [" + addrType + "]");
            switch (addrType) {
                case 0: {
                    this.setDHCPServerEnabled(false);
                    String[] fixedAddr = new String[]{this.getMountPrefix() + "MANUALBUTTON"};
                    this.setDHCPClientSelection(fixedAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", false);
                    break;
                }
                case 1: {
                    this.setDHCPServerEnabled(false);
                    String[] dhcpClntAddr = new String[]{this.getMountPrefix() + "DHCPBUTTON"};
                    this.setDHCPClientSelection(dhcpClntAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPSERVERINFOBOX", false);
                    break;
                }
                case 2: {
                    if (!this.configured && this.m_cdDHCPServerAddrRange.length > 0) {
                        this.m_sDHCPServerAddrRange = this.m_cdDHCPServerAddrRange[0].getName();
                    }
                    this.setDHCPServerEnabled(true);
                    this.setDHCPServerAddrRange(this.getDHCPServerAddrRange());
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPServerEnabled", false);
                    break;
                }
                default: {
                    Trace.trace(TRACE_MASKT, "CustomerChoice: Use static/dhcpC setting sent to us at top of prepare");
                }
            }
            if (this.offerPartComm) {
                if (this.configured) {
                    Trace.trace(TRACE_MASKT, "Partition Communication allowed. Use previous setting: " + this.m_bPartitionCommunication);
                } else {
                    this.m_bPartitionCommunication = this.netIfConfig.isLparCommunication();
                    Trace.trace(TRACE_MASKT, "Partition Communication allowed. Use config file setting: " + this.m_bPartitionCommunication);
                }
            } else {
                Trace.trace(TRACE_MASKT, "Partition Communication not allowed.(see xml file)");
            }
            this.configured = true;
        } else {
            Trace.trace(TRACE_MASKT, "This lan not found in config file, or we're running RedHat");
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.prepare()");
    }

    public void panelAction(TaskActionEvent event) {
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKF, "-> IPAddressBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("ipaddresspanel");
        if (command.endsWith("detailsOkButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IPAddressBean) ");
            Trace.trace(TRACE_MASKF, "getDHCPClientSelection[0] = " + this.getDHCPClientSelection()[0]);
            Trace.trace(TRACE_MASKF, "getMountPrefix = " + this.getMountPrefix());
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            Trace.trace(TRACE_MASKF, " Data Read: getPublicPrivateSettingSelection() = " + this.getPublicPrivateSettingSelection()[0]);
            Trace.trace(TRACE_MASKF, " Data Read: isPartitionCommunication() = " + this.isPartitionCommunication());
            Trace.trace(TRACE_MASKF, " Data Read: isDHCPServerEnabled() = " + this.isDHCPServerEnabled());
            Trace.trace(TRACE_MASKF, " Data Read: getDHCPClientSelection() = " + this.getDHCPClientSelection()[0]);
            Trace.trace(TRACE_MASKF, " Data Read: getIPAddr() = " + this.getIPAddr());
            Trace.trace(TRACE_MASKF, " Data Read: getMask() = " + this.getMask());
            Trace.trace(TRACE_MASKF, " Data Read: getMacAddr() = " + this.getMacAddr());
            Trace.trace(TRACE_MASKF, " Data Read: configured = " + this.configured);
            if (this.getPublicPrivateSettingSelection()[0].endsWith("PRIVATEBUTTON")) {
                this._netif.setPrivateIf(true);
            } else {
                this._netif.setPrivateIf(false);
            }
            this._netif.setMediaSpeed(this.getMediaSpeed());
            this._netif.setPartitionCommunication(this.isPartitionCommunication());
            this._netif.setDhcpServer(this.isDHCPServerEnabled());
            this._netif.setConfigured(this.configured);
            boolean done = false;
            if (this.m_cdDHCPServerAddrRange != null) {
                for (int i = 0; i < this.m_cdDHCPServerAddrRange.length && !done; ++i) {
                    Trace.trace(TRACE_MASKT, "m_cdDHCPServerAddrRange[" + i + "].getName() = " + this.m_cdDHCPServerAddrRange[i].getName());
                    if (!this.m_sDHCPServerAddrRange.equals(this.m_cdDHCPServerAddrRange[i].getName())) continue;
                    this._netif.setDhcpServerRangeConfig(this.dhcpServerRangeConfigArray[i]);
                    Trace.trace(TRACE_MASKT, "dhcpServerRangeConfigArray[i].getStart() = " + this.dhcpServerRangeConfigArray[i].getStart());
                    done = true;
                }
            }
            try {
                this._netif.setIpAddress(InetAddress.getByName(this.getIPAddr()));
                this._netif.setNetworkMask(InetAddress.getByName(this.getMask()));
                Trace.trace(TRACE_MASKF, "\n getMask() = " + this.getMask());
                Trace.trace(TRACE_MASKF, "_netif.getNetMask() = " + this._netif.getNetMask() + "\n");
            }
            catch (UnknownHostException exc) {
                Trace.trace(TRACE_MASKF, "ILLEGAL DATA ENTERED!   UnknownHostException!!  ");
                HException hexc = new HException(exc);
                new FrameworkLog(_logInfo, 18, hexc).log();
            }
            String dhcpState = this.getDHCPClientSelection()[0];
            dhcpState = dhcpState.substring(dhcpState.lastIndexOf(".") + 1);
            if (dhcpState.startsWith("DHCP")) {
                this._netif.setDhcpClient(true);
            } else {
                this._netif.setDhcpClient(false);
            }
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getIpAddress(): " + this._netif.getIpAddr());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getNetworkMask(): " + this._netif.getNetMask());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getAdapterType(): " + this._netif.getAdapterType());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getMacAddress(): " + this._netif.getMacAddress());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isDhcpClient(): " + this._netif.isDhcpClient());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isConfigured(): " + this._netif.isConfigured());
            request.setData("panel", "ipaddresspanel");
            request.setData("dataupdates", this._netif);
            request.setData("data", this._netifIndex);
            this.postTaskletRequest(request);
        } else if (command.endsWith("detailsCancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IPAddressBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            boolean dhcpClientFlag = false;
            String dhcpClientState = this.getDHCPClientSelection()[0];
            dhcpClientState = dhcpClientState.substring(dhcpClientState.lastIndexOf(".") + 1);
            if (dhcpClientState.startsWith("DHCP")) {
                dhcpClientFlag = true;
            }
            if (this._netif.isDhcpClient() != dhcpClientFlag || !this._netif.getIpAddr().equals(this.m_sIPAddr) || !this._netif.getNetMask().equals(this.m_sMask)) {
                ((DetailsFrameBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKT, "IPAddressBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKF, "<- IPAddressBean.parentalAction()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.storeElement(this.getMountPrefix() + "PublicPrivateGroup");
        this.userTaskManager.storeElement(this.getMountPrefix() + "PartitionComm");
        this.userTaskManager.storeElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.storeElement(this.getMountPrefix() + "AddressRange");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DHCPServerEnabled");
        Trace.trace(TRACE_MASKT, "m_sIPAddr " + this.m_sIPAddr);
        Trace.trace(TRACE_MASKT, "m_sMask " + this.m_sMask);
        Trace.trace(TRACE_MASKT, "m_sMacAddr " + this.m_sMacAddr);
        Trace.trace(TRACE_MASKT, "m_sPublicPrivateSettingSelection " + this.m_sPublicPrivateSettingSelection[0]);
        Trace.trace(TRACE_MASKT, "m_bPartitionCommunication " + this.m_bPartitionCommunication);
        Trace.trace(TRACE_MASKT, "m_sMediaSpeed " + this.m_sMediaSpeed);
        Trace.trace(TRACE_MASKT, "m_sDHCPClientSelection " + this.m_sDHCPClientSelection[0]);
        Trace.trace(TRACE_MASKT, "m_sDHCPServerAddrRange " + this.m_sDHCPServerAddrRange);
        Trace.trace(TRACE_MASKT, "m_bDHCPServerEnabled " + this.m_bDHCPServerEnabled);
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "PublicPrivateGroup");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "PartitionComm");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "AddressRange");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DHCPServerEnabled");
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.refreshMyElements()");
    }

    public void setNetworkInterface(NetworkInterfaceInformation netif, Integer netifIndex, NetworkSettingsConfig networkSettingsConfig) {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.setNetworkInterface()");
        this.ifName = netif.getIfname();
        this.setIPAddr(netif.getIpAddr().trim());
        this.setMask(netif.getNetMask().trim());
        String macaddress = netif.getMacAddress();
        int length = macaddress.length();
        this.macaddrText = "";
        for (int i = 0; i < length && i < 24; i += 2) {
            this.macaddrText = this.macaddrText + macaddress.substring(i, i + 2);
            if (i >= length - 2) continue;
            this.macaddrText = this.macaddrText + ":";
        }
        Trace.trace(TRACE_MASKT, "macaddrText = " + this.macaddrText);
        this.setMacAddr(this.macaddrText + "   " + SettingsConstants.CARDTYPES[netif.getAdapterType()]);
        if (netif.isDhcpServer()) {
            this.m_bDHCPServerEnabled = true;
            this.selectedRangeConfig = netif.getDhcpServerRangeConfig();
            String range = this.selectedRangeConfig.getStart() + " - " + this.selectedRangeConfig.getEnd();
            Trace.trace(TRACE_MASKT, "DHCP Server Range: " + range);
            this.m_sDHCPServerAddrRange = range;
        } else {
            this.m_bDHCPServerEnabled = false;
        }
        this.MCPLinux = this.isMCPLinux();
        this.configured = netif.isConfigured();
        this.m_sMediaSpeed = netif.getMediaSpeed();
        this.m_bPartitionCommunication = netif.isPartitionCommunication();
        Trace.trace(TRACE_MASKT, "m_sIPAddr " + this.m_sIPAddr);
        Trace.trace(TRACE_MASKT, "m_sMask " + this.m_sMask);
        Trace.trace(TRACE_MASKT, "m_sMacAddr " + this.m_sMacAddr);
        Trace.trace(TRACE_MASKT, "m_bDHCPServerEnabled " + this.m_bDHCPServerEnabled);
        Trace.trace(TRACE_MASKT, "m_sDHCPServerAddrRange " + this.m_sDHCPServerAddrRange);
        Trace.trace(TRACE_MASKT, "MCPLinux =" + this.MCPLinux);
        Trace.trace(TRACE_MASKT, "Configured =" + this.configured);
        Trace.trace(TRACE_MASKT, "m_sMediaSpeed " + this.m_sMediaSpeed);
        Trace.trace(TRACE_MASKT, "PartitionCommunication =" + this.m_bPartitionCommunication);
        this._netif = netif;
        this._netifIndex = netifIndex;
        this.netSetConfig = networkSettingsConfig;
        this.offerPartComm = this.netSetConfig.isOfferLPARCheckbox();
        if (this.netSetConfig != null) {
            this.netIfConfigArray = networkSettingsConfig.getNetworkInterfacesArray();
            boolean netIntConfFound = false;
            for (int i = 0; i < this.netIfConfigArray.length && !netIntConfFound; ++i) {
                Trace.trace(TRACE_MASKF, "interfaceID = " + this.netIfConfigArray[i].getInterfaceID());
                if (!this.ifName.equals(this.netIfConfigArray[i].getInterfaceID())) continue;
                this.netIfConfig = this.netIfConfigArray[i];
                netIntConfFound = true;
                Trace.trace(TRACE_MASKF, this.ifName + " is adapter number " + i + " in the config file");
            }
            if (!netIntConfFound) {
                Trace.trace(TRACE_MASKF, this.ifName + " is not found in the config file");
            }
            this.dhcpServerRangeConfigArray = this.netSetConfig.getDHCPServerRangesArray();
            if (netif.isDhcpServer()) {
                this.m_sDHCPServerAddrRange = netif.getDhcpServerRangeConfig().getStart() + " - " + netif.getDhcpServerRangeConfig().getEnd();
                Trace.trace(TRACE_MASKF, " m_sDHCPServerAddrRange = [" + this.m_sDHCPServerAddrRange + "]");
            }
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.setNetworkInterface()");
    }

    public boolean isMCPLinux() {
        String opsys = System.getProperty("os.name");
        try {
            BufferedReader in = new BufferedReader(new FileReader("/etc/redhat-release"));
            Trace.trace(TRACE_MASKT, "Detected RedHat Linux");
            this.MCPLinux = false;
        }
        catch (FileNotFoundException exc) {
            Trace.trace(TRACE_MASKT, "Detected non-RedHat Linux");
            this.MCPLinux = true;
        }
        return this.MCPLinux;
    }
}

